
import gurobipy as gp

# Create a new model
m = gp.Model("microphone_optimization")

# Create variables
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="regular_mics") # number of regular microphones
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="premium_mics") # number of premium microphones


# Set objective function
m.setObjective(80*x1 + 95*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(75*x1 + 100*x2 <= 30000, "budget_constraint")
m.addConstr(x1 + x2 <= 300, "demand_constraint")
m.addConstr(x1 >= 0, "non_negativity_x1")
m.addConstr(x2 >= 0, "non_negativity_x2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of regular microphones: {x1.x}")
    print(f"Number of premium microphones: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

