
from gurobipy import *

# Create a new model
m = Model("Microphone_Inventory")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="regular_microphones", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="premium_microphones", lb=0)

# Set the objective function
m.setObjective(80*x1 + 95*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(75*x1 + 100*x2 <= 30000, "budget_constraint")
m.addConstr(x1 + x2 <= 300, "demand_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of regular microphones: {x1.x}")
    print(f"Number of premium microphones: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
