
import gurobi

def solve_microphone_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="regular_microphones", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="premium_microphones", lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(80*x1 + 95*x2, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(75*x1 + 100*x2 <= 30000, name="budget_constraint")

    # Demand constraint
    model.addConstr(x1 + x2 <= 300, name="demand_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of regular microphones: {x1.varValue}")
        print(f"Optimal number of premium microphones: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_microphone_problem()
