
import gurobipy as gp

# Create a new model
m = gp.Model("Washing_Dryer_Installation")

# Create variables
washing_machines = m.addVar(vtype=gp.GRB.CONTINUOUS, name="washing_machines")
dryers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="dryers")


# Set objective function
m.setObjective(200 * washing_machines + 150 * dryers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * washing_machines + 10 * dryers <= 2000, "Plumber_Time")
m.addConstr(15 * washing_machines + 25 * dryers <= 3000, "Electrician_Time")
m.addConstr(washing_machines >= 0, "Non_negative_washing_machines")  # Ensure non-negative values
m.addConstr(dryers >= 0, "Non_negative_dryers")  # Ensure non-negative values


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Washing Machines to Install: {washing_machines.x}")
    print(f"Number of Dryers to Install: {dryers.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

