
from gurobipy import *

# Create a new model
m = Model("Washing_Machine_and_Dryer_Installation")

# Create variables
x1 = m.addVar(name="washing_machines", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="dryers", vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(200*x1 + 150*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 10*x2 <= 2000, name="plumber_time")
m.addConstr(15*x1 + 25*x2 <= 3000, name="electrician_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {int(x1.x)}, {x2.varName} = {int(x2.x)}")
    print(f"Maximum profit: ${int(m.objVal)}")
else:
    print("No optimal solution found.")
