
import gurobipy as gp

# Create a new model
model = gp.Model("Washing_Machines_Dryers")

# Define variables
x1 = model.addVar(name="washing_machines", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="dryers", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: maximize profit
model.setObjective(200*x1 + 150*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(20*x1 + 10*x2 <= 2000, name="plumber_time")
model.addConstr(15*x1 + 25*x2 <= 3000, name="electrician_time")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of washing machines: {x1.varValue}")
    print(f"Optimal number of dryers: {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
