
import gurobipy as gp

# Create a new model
m = gp.Model("advertising_optimization")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Banana_Livestream_Ads")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Durian_TV_Ads")
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Orange_Premium_Video_Ads")


# Set objective function
m.setObjective(300000*x1 + 10000*x2 + 12000*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1500*x1 + 300*x2 + 500*x3 <= 20000, "Budget_Constraint")
m.addConstr(x2 <= 15, "Durian_TV_Limit")
m.addConstr(x3 <= (x1 + x2 + x3)/3, "Orange_Premium_Video_Ratio")
m.addConstr(x1 >= 0.05*(x1 + x2 + x3), "Banana_Livestream_Ratio")
m.addConstr(x1 >=0, "Banana_nonneg")
m.addConstr(x2 >=0, "Durian_nonneg")
m.addConstr(x3 >=0, "Orange_nonneg")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('\nOptimal Solution Found:\n')
    print(f'Banana Livestream Ads: {x1.x}')
    print(f'Durian TV Ads: {x2.x}')
    print(f'Orange Premium Video Ads: {x3.x}')
    print(f'Total Viewers: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

