
import gurobipy as gp

# Create a new model
m = gp.Model("advertising")

# Define the variables
x1 = m.addVar(name="Banana Livestream ads", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="Durian TV ads", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="Orange Premium Video ads", vtype=gp.GRB.INTEGER)

# Objective function: maximize the total audience
m.setObjective(300000*x1 + 10000*x2 + 12000*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(1500*x1 + 300*x2 + 500*x3 <= 20000, name="budget_constraint")
m.addConstr(x2 <= 15, name="durian_tv_limit")
m.addConstr(2*x3 <= x1 + x2, name="orange_premium_video_limit")
m.addConstr(0.95*x1 - 0.05*x2 - 0.05*x3 >= 0, name="banana_livestream_min")
m.addConstr(x1 >= 0, name="x1_non_negative")
m.addConstr(x2 >= 0, name="x2_non_negative")
m.addConstr(x3 >= 0, name="x3_non_negative")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Banana Livestream ads: {x1.varValue}")
    print(f"Durian TV ads: {x2.varValue}")
    print(f"Orange Premium Video ads: {x3.varValue}")
    print(f"Total audience: {300000*x1.varValue + 10000*x2.varValue + 12000*x3.varValue}")
else:
    print("No optimal solution found.")
