
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Supplementation")

# Create variables
regular = m.addVar(lb=0, name="regular")  # Grams of regular supplementation
premium = m.addVar(lb=0, name="premium")  # Grams of premium supplementation

# Set objective function
m.setObjective(0.04 * regular + 0.08 * premium, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.20 * regular + 0.25 * premium >= 30, "IronRequirement")
m.addConstr(0.30 * regular + 0.40 * premium >= 50, "CalciumRequirement")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Regular supplementation: {regular.x:.2f} grams")
    print(f"Premium supplementation: {premium.x:.2f} grams")
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

