
from gurobipy import *

# Create a new model
m = Model("David_Supplementation")

# Add variables
x1 = m.addVar(lb=0, name="regular_supplementation")
x2 = m.addVar(lb=0, name="premium_supplementation")

# Set the objective function
m.setObjective(0.04*x1 + 0.08*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.20*x1 + 0.25*x2 >= 30, "iron_requirement")
m.addConstr(0.30*x1 + 0.40*x2 >= 50, "calcium_requirement")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular supplementation: {x1.x} grams")
    print(f"Premium supplementation: {x2.x} grams")
    print(f"Total cost: ${0.04*x1.x + 0.08*x2.x:.2f}")
else:
    print("No optimal solution found")
