
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="regular_supplementation", lb=0, ub=float('inf'))
    x2 = model.addVar(name="premium_supplementation", lb=0, ub=float('inf'))

    # Objective function: minimize 0.04x1 + 0.08x2
    model.setObjective(0.04 * x1 + 0.08 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.20 * x1 + 0.25 * x2 >= 30, name="iron_requirement")
    model.addConstr(0.30 * x1 + 0.40 * x2 >= 50, name="calcium_requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Regular supplementation: {x1.varValue} grams")
        print(f"Premium supplementation: {x2.varValue} grams")
        print(f"Total cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
