
import gurobipy as gp

# Create a new model
m = gp.Model("Sid's Diet")

# Create variables
hamburger = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburger")
pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pasta")


# Set objective function
m.setObjective(3 * hamburger + 4 * pasta, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(hamburger >= 2, "meat")
m.addConstr(0.5 * hamburger + pasta >= 1, "dairy")
m.addConstr(hamburger + pasta >= 4, "vegetables")
m.addConstr(hamburger + 2 * pasta >= 3, "grains")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Number of hamburgers: {hamburger.x}")
    print(f"Number of pasta plates: {pasta.x}")
    print(f"Minimum cost: ${m.objVal}")

