
from gurobipy import *

# Create a model
m = Model("Sid's Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hamburgers")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="pasta")

# Set objective function
m.setObjective(3*x1 + 4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 >= 2, "meat_requirement")
m.addConstr(0.5*x1 + x2 >= 1, "dairy_requirement")
m.addConstr(x1 + x2 >= 4, "vegetables_requirement")
m.addConstr(x1 + 2*x2 >= 3, "grains_requirement")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hamburgers: {x1.x}")
    print(f"Pasta: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
