
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hamburgers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="plates_of_pasta", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(3*x1 + 4*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 >= 2, name="meat_requirement")
    model.addConstr(0.5*x1 + x2 >= 1, name="dairy_requirement")
    model.addConstr(x1 + x2 >= 4, name="vegetables_requirement")
    model.addConstr(x1 + 2*x2 >= 3, name="grains_requirement")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of hamburgers: {x1.varValue}")
        print(f"Number of plates of pasta: {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
