
import gurobipy as gp

# Create a new model
model = gp.Model("Meat_Factory")

# Create variables
burgers = model.addVar(vtype=gp.GRB.CONTINUOUS, name="burgers")
hotdogs = model.addVar(vtype=gp.GRB.CONTINUOUS, name="hotdogs")

# Set objective function
model.setObjective(0.3 * burgers + 0.2 * hotdogs, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * burgers + 2 * hotdogs <= 2000, "meat_constraint")
model.addConstr(2 * burgers + 1 * hotdogs <= 1800, "binding_constraint")
model.addConstr(burgers >= 0, "burgers_nonnegative")
model.addConstr(hotdogs >= 0, "hotdogs_nonnegative")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${model.objVal:.2f}")
    print(f"Number of Burgers: {burgers.x:.2f}")
    print(f"Number of Hotdogs: {hotdogs.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

