
from gurobipy import *

# Create a new model
m = Model("Meat_Factory_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="burgers")
x2 = m.addVar(lb=0, name="hot_dogs")

# Set the objective function
m.setObjective(0.30*x1 + 0.20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 <= 2000, "meat_constraint")
m.addConstr(2*x1 + x2 <= 1800, "binding_agent_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of burgers: {x1.x}")
    print(f"Number of hot-dogs: {x2.x}")
    print(f"Total Revenue: ${0.30*x1.x + 0.20*x2.x:.2f}")
else:
    print("No optimal solution found")
