
import gurobipy as gp

# Create a new model
model = gp.Model("meat_factory_optimization")

# Define variables
x1 = model.addVar(name="burgers", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="hot-dogs", lb=0, vtype=gp.GRB.CONTINUOUS)

# Set objective function
model.setObjective(0.30*x1 + 0.20*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x1 + 2*x2 <= 2000, name="meat_constraint")
model.addConstr(2*x1 + x2 <= 1800, name="binding_agent_constraint")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of burgers: {x1.varValue}")
    print(f"Optimal number of hot-dogs: {x2.varValue}")
    print(f"Max revenue: {model.objVal}")
else:
    print("The model is infeasible.")
arValue}")
        print(f"Max revenue: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
