
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tech_company_profit")

# Create variables
phones = m.addVar(lb=0, vtype=GRB.INTEGER, name="phones")
laptops = m.addVar(lb=0, vtype=GRB.INTEGER, name="laptops")


# Set objective function
m.setObjective(300 * phones + 500 * laptops, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * phones + 4 * laptops <= 200, "silicon_chips")
m.addConstr(5 * phones + 6 * laptops <= 250, "engineering_time")
m.addConstr(3 * phones + 1 * laptops <= 300, "assembly_time")
m.addConstr(phones >= 30, "min_phones")
m.addConstr(laptops >= 30, "min_laptops")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of phones to produce: {phones.x}")
    print(f"Number of laptops to produce: {laptops.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

