
from gurobipy import *

# Create a new model
m = Model("Electronics_Production")

# Define variables
x1 = m.addVar(lb=30, vtype=GRB.INTEGER, name="phones")
x2 = m.addVar(lb=30, vtype=GRB.INTEGER, name="laptops")

# Set objective function
m.setObjective(300*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 4*x2 <= 200, "silicon_chips")
m.addConstr(5*x1 + 6*x2 <= 250, "engineering_time")
m.addConstr(3*x1 + x2 <= 300, "assembly_time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Phones: {x1.x}")
    print(f"Laptops: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found.")
