
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=30, name="phones")  # at least 30 phones
    x2 = model.addVar(lb=30, name="laptops")  # at least 30 laptops

    # Objective function: Maximize profit
    model.setObjective(300*x1 + 500*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 4*x2 <= 200, name="silicon_chips")
    model.addConstr(5*x1 + 6*x2 <= 250, name="engineering_time")
    model.addConstr(3*x1 + x2 <= 300, name="assembly_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Phones: {x1.varValue}")
        print(f"Laptops: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
