
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
mining_investment = m.addVar(name="mining_investment")
logging_investment = m.addVar(name="logging_investment")

# Set objective function
m.setObjective(0.09 * mining_investment + 0.05 * logging_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(mining_investment + logging_investment <= 100000, "total_investment")
m.addConstr(mining_investment >= 0.3 * 100000, "min_mining_investment")
m.addConstr(logging_investment <= 0.55 * 100000, "max_logging_investment")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal mining investment: {mining_investment.x}")
    print(f"Optimal logging investment: {logging_investment.x}")
    print(f"Optimal return: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

