
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(name="mining_investment", lb=0)
x2 = m.addVar(name="logging_investment", lb=0)

# Set the objective function
m.setObjective(0.09*x1 + 0.05*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 100000, name="total_investment")
m.addConstr(x1 >= 30000, name="min_mining_investment")
m.addConstr(x2 <= 55000, name="max_logging_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in mining: {x1.x}")
    print(f"Amount invested in logging: {x2.x}")
    print(f"Total return: {m.objVal}")
else:
    print("No optimal solution found")
