
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="mining_investment", lb=0)
    x2 = model.addVar(name="logging_investment", lb=0)

    # Objective function: maximize 0.09*x1 + 0.05*x2
    model.setObjective(0.09 * x1 + 0.05 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 == 100000, name="total_investment")
    model.addConstr(x1 >= 30000, name="min_mining_investment")
    model.addConstr(x2 <= 55000, name="max_logging_investment")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in mining industry: $", x1.varValue)
        print("Optimal investment in logging industry: $", x2.varValue)
        print("Maximum return: ", 0.09 * x1.varValue + 0.05 * x2.varValue)
    else:
        print("The model is infeasible")

solve_investment_problem()
