
import gurobipy as gp

# Create a new model
m = gp.Model("Film_Production_Advertising")

# Define variables
x1 = m.addVar(name="ads_in_malls", lb=0, vtype=gp.GRB.INTEGER)  # ads in malls
x2 = m.addVar(name="ads_at_bus_stops", lb=0, vtype=gp.GRB.INTEGER)  # ads at bus stops
x3 = m.addVar(name="ads_in_theatres", lb=0, vtype=gp.GRB.INTEGER)  # ads in theatres

# Objective function: Maximize viewership
m.setObjective(50000*x1 + 10000*x2 + 20000*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(5000*x1 + 1000*x2 + 3000*x3 <= 30000, name="budget_constraint")
m.addConstr(x2 <= 20, name="bus_stop_ads_limit")
m.addConstr(2*x3 <= x1 + x2, name="theatre_ads_limit")
m.addConstr(4*x1 >= x2 + x3, name="mall_ads_minimum")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Ads in malls: {x1.varValue}")
    print(f"Ads at bus stops: {x2.varValue}")
    print(f"Ads in theatres: {x3.varValue}")
    print(f"Max Viewership: {m.objVal}")
else:
    print("No optimal solution found")
