
from gurobipy import Model, GRB

# Create a new model
m = Model("fruit_stand")

# Create variables
lemons = m.addVar(lb=0, vtype=GRB.INTEGER, name="lemons")
bananas = m.addVar(lb=0, vtype=GRB.INTEGER, name="bananas")

# Set objective function
m.setObjective(2 * lemons + bananas, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * lemons + 1.5 * bananas <= 1000, "budget")
m.addConstr(lemons >= 250, "min_lemons")
m.addConstr(lemons <= 300, "max_lemons")
m.addConstr(bananas <= (1/3) * lemons, "banana_limit")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Lemons: %g' % lemons.x)
    print('Bananas: %g' % bananas.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

