
from gurobipy import *

# Create a new model
m = Model("Food_Store_Profit")

# Define variables
x1 = m.addVar(lb=250, ub=300, vtype=GRB.INTEGER, name="lemons")
x2 = m.addVar(vtype=GRB.INTEGER, name="bananas")

# Set the objective function
m.setObjective(2*x1 + x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 1.5*x2 <= 1000, "budget_constraint")
m.addConstr(x2 <= (1/3)*x1, "banana_lemon_ratio")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of lemons: {x1.x}")
    print(f"Number of bananas: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
