
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='lemons', lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # lemons
    x2 = model.addVar(name='bananas', lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # bananas

    # Define the objective function
    model.setObjective(2*x1 + 1*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3*x1 + 1.5*x2 <= 1000)  # budget constraint
    model.addConstr(x1 >= 250)  # minimum lemons sold
    model.addConstr(x1 <= 300)  # maximum lemons sold
    model.addConstr(x2 <= x1/3)  # maximum bananas sold

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: lemons = {x1.varValue}, bananas = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
