
import gurobipy as gp

# Create a new model
m = gp.Model("baseball_game")

# Create variables
slow_balls = m.addVar(vtype=gp.GRB.INTEGER, name="slow_balls")
fast_balls = m.addVar(vtype=gp.GRB.INTEGER, name="fast_balls")

# Set objective function
m.setObjective(3 * slow_balls + 5 * fast_balls, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(slow_balls >= 5, "min_slow")
m.addConstr(fast_balls >= 3, "min_fast")
m.addConstr(slow_balls <= 8, "max_slow")
m.addConstr(fast_balls <= 8, "max_fast")
m.addConstr(slow_balls + fast_balls <= 12, "total_balls")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal}")
    print(f"Slow balls: {slow_balls.x}")
    print(f"Fast balls: {fast_balls.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

