
from gurobipy import *

# Create a new model
m = Model("Ball_Hitting_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="slow_balls")
x2 = m.addVar(vtype=GRB.INTEGER, name="fast_balls")

# Set objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 5, "min_slow_balls")
m.addConstr(x2 >= 3, "min_fast_balls")
m.addConstr(x1 <= 8, "max_slow_balls")
m.addConstr(x2 <= 8, "max_fast_balls")
m.addConstr(x1 + x2 <= 12, "total_max_balls")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hit {x1.x} slow balls and {x2.x} fast balls.")
    print(f"Total points: {3*x1.x + 5*x2.x}")
else:
    print("No optimal solution found.")

