
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=8, name="slow_balls", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, ub=8, name="fast_balls", vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 3*x1 + 5*x2
    model.setObjective(3*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 >= 5, name="min_slow_balls")
    model.addConstr(x2 >= 3, name="min_fast_balls")
    model.addConstr(x1 <= 8, name="max_slow_balls")
    model.addConstr(x2 <= 8, name="max_fast_balls")
    model.addConstr(x1 + x2 <= 12, name="total_balls")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: slow balls = {x1.varValue}, fast balls = {x2.varValue}")
    else:
        print("No optimal solution found.")

solve_problem()
