
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("electronics_production")

# Create variables
dvd = m.addVar(vtype=GRB.INTEGER, name="dvd")  # Number of DVD players
projector = m.addVar(vtype=GRB.INTEGER, name="projector")  # Number of projectors

# Set objective function
m.setObjective(250 * dvd + 200 * projector, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * dvd + 3 * projector <= 250, "silicon_chips")
m.addConstr(6 * dvd + 5 * projector <= 200, "engineering_time")
m.addConstr(2.5 * dvd + 2 * projector <= 240, "assembly_time")
m.addConstr(dvd >= 30, "min_dvd")
m.addConstr(projector >= 30, "min_projector")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"DVD players: {dvd.x}")
    print(f"Projectors: {projector.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

