
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='DVD_players', lb=0)  # Number of DVD players
    x2 = model.addVar(name='projectors', lb=0)   # Number of projectors

    # Objective function: Maximize profit
    model.setObjective(250 * x1 + 200 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x1 + 3 * x2 <= 250, name='silicon_chips')
    model.addConstr(6 * x1 + 5 * x2 <= 200, name='engineering_time')
    model.addConstr(2.5 * x1 + 2 * x2 <= 240, name='assembly_time')
    model.addConstr(x1 >= 30, name='min_DVD_players')
    model.addConstr(x2 >= 30, name='min_projectors')

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: DVD players = {x1.varValue}, projectors = {x2.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
