
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("lipstick_production")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="cream_lipsticks") # Number of cream lipsticks
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="matte_lipsticks") # Number of matte lipsticks


# Set objective function
m.setObjective(70*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.5*x1 + 5*x2 <= 300, "raw_materials")
m.addConstr(5*x1 + 3*x2 <= 400, "mixing")
m.addConstr(2*x1 + 1.5*x2 <= 200, "packing")
m.addConstr(x1 >= 0, "cream_non_negative")
m.addConstr(x2 >= 0, "matte_non_negative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of cream lipsticks: {x1.x:.2f}")
    print(f"Number of matte lipsticks: {x2.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

