
from gurobipy import *

# Create a new model
model = Model("Lipstick_Production")

# Define variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="cream_lipsticks")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="matte_lipsticks")

# Set the objective function
model.setObjective(70*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3.5*x1 + 5*x2 <= 300, "raw_materials")
model.addConstr(5*x1 + 3*x2 <= 400, "mixing")
model.addConstr(2*x1 + 1.5*x2 <= 200, "packing")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")
