
import gurobi

def solve_lipstick_production():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="cream_lipsticks", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="matte_lipsticks", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(70 * x1 + 100 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3.5 * x1 + 5 * x2 <= 300, name="raw_materials")
    model.addConstr(5 * x1 + 3 * x2 <= 400, name="mixing")
    model.addConstr(2 * x1 + 1.5 * x2 <= 200, name="packing")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cream lipsticks: {x1.varValue}")
        print(f"Matte lipsticks: {x2.varValue}")
        print(f"Total profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_lipstick_production()
