
import gurobipy as gp

# Create a new model
m = gp.Model("Cosmetics Advertising")

# Create variables
social_media_ads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="social_media_ads")
tv_ads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tv_ads")


# Set objective function
m.setObjective(30000 * social_media_ads + 50000 * tv_ads, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * social_media_ads + 3 * tv_ads >= 20, "young_girls_reach")
m.addConstr(1 * social_media_ads + 7 * tv_ads >= 30, "middle_aged_women_reach")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal}")
    print(f"Number of social media ads: {social_media_ads.x}")
    print(f"Number of TV ads: {tv_ads.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

