
import gurobipy as gp

# Create a new model
model = gp.Model("cosmetics_company")

# Define the variables
x1 = model.addVar(name="social_media_commercials", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="television_commercials", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(30000*x1 + 50000*x2, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(5*x1 + 3*x2 >= 20, name="young_girls_constraint")
model.addConstr(x1 + 7*x2 >= 30, name="middle_aged_women_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of social media commercials: {x1.varValue}")
    print(f"Number of television commercials: {x2.varValue}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found.")
