
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
milk = m.addVar(lb=0, name="milk")  # Servings of milk
cheese = m.addVar(lb=0, name="cheese")  # Servings of cheese

# Set objective function: Minimize cost
m.setObjective(2 * milk + 4 * cheese, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * milk + 8 * cheese >= 100, "calcium_req")  # Calcium requirement
m.addConstr(5 * milk + 6 * cheese >= 80, "vitamin_d_req")  # Vitamin D requirement


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Servings of Milk: {milk.x}")
    print(f"Servings of Cheese: {cheese.x}")
    print(f"Minimum Cost: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

