
from gurobipy import *

# Create a new model
m = Model("Calcium_Vitamin_D")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="servings_of_milk")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="servings_of_cheese")

# Set the objective function
m.setObjective(2*x1 + 4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 8*x2 >= 100, "calcium_requirement")
m.addConstr(5*x1 + 6*x2 >= 80, "vitamin_d_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Servings of milk: {x1.x}")
    print(f"Servings of cheese: {x2.x}")
    print(f"Total cost: ${2*x1.x + 4*x2.x:.2f}")
else:
    print("No optimal solution found")
