
import gurobipy as gp

# Create a new model
model = gp.Model("Calcium_Vitamin_Optimization")

# Define the variables
x1 = model.addVar(name="milk", lb=0)  # servings of milk
x2 = model.addVar(name="cheese", lb=0)  # servings of cheese

# Define the objective function
model.setObjective(2*x1 + 4*x2, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(10*x1 + 8*x2 >= 100, name="calcium_constraint")
model.addConstr(5*x1 + 6*x2 >= 80, name="vitaminD_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Servings of milk: {x1.varValue}")
    print(f"Servings of cheese: {x2.varValue}")
    print(f"Total cost: ${2*x1.varValue + 4*x2.varValue:.2f}")
else:
    print("No optimal solution found.")
