
import gurobipy as gp

# Create a new model
m = gp.Model("DessertFactory")

# Create variables
cakes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cakes")
pies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pies")


# Set objective function
m.setObjective(4 * cakes + 3 * pies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * cakes + 5 * pies <= 1000, "sugar_constraint")
m.addConstr(5 * cakes + 3 * pies <= 1200, "flour_constraint")
m.addConstr(cakes >= 0, "cakes_nonnegative")
m.addConstr(pies >= 0, "pies_nonnegative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal}")
    print(f"Number of Cakes: {cakes.x}")
    print(f"Number of Pies: {pies.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

