
from gurobipy import *

# Create a new model
m = Model("Dessert_Factory")

# Define variables
x1 = m.addVar(name="cakes", lb=0)
x2 = m.addVar(name="pies", lb=0)

# Set the objective function
m.setObjective(4*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 5*x2 <= 1000, name="sugar_constraint")
m.addConstr(5*x1 + 3*x2 <= 1200, name="flour_constraint")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
