
import gurobipy as gp

# Create a new model
model = gp.Model("Dessert_Factory_Optimization")

# Define the variables
x1 = model.addVar(name="cakes", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="pies", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(4*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4*x1 + 5*x2 <= 1000, name="sugar_constraint")
model.addConstr(5*x1 + 3*x2 <= 1200, name="flour_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: cakes = {x1.varValue}, pies = {x2.varValue}")
    print(f"Maximum revenue: ${4*x1.varValue + 3*x2.varValue:.2f}")
else:
    print("No optimal solution found.")
