
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("paint_blend")

# Create variables
x = model.addVar(lb=0, ub=1, name="x") # fraction of Egret paint
y = model.addVar(lb=0, ub=1, name="y") # fraction of Crane paint

# Set objective function
model.setObjective(0.40 * x + 1.20 * y, GRB.MINIMIZE)

# Add constraints
model.addConstr(60 * x + 85 * y >= 70, "quality_constraint")
model.addConstr(x + y == 1, "fraction_constraint")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal blend:")
    print(f"  Egret paint (x): {x.x}")
    print(f"  Crane paint (y): {y.x}")
    print(f"Minimum cost: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

