
from gurobipy import *

# Create a model
m = Model("Paint_Mix")

# Define variables
x = m.addVar(name='Egret_Paint_Fraction', lb=0, ub=1)
y = m.addVar(name='Crane_Paint_Fraction', lb=0, ub=1)

# Objective function: Minimize cost
m.setObjective(0.4*x + 1.2*y, GRB.MINIMIZE)

# Constraints
m.addConstr(x + y == 1, name='Total_Fraction')
m.addConstr(60*x + 85*y >= 70, name='Quality_Rating')

# Solve the model
m.optimize()

if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Egret Paint Fraction: {x.x}")
    print(f"Crane Paint Fraction: {y.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")

