
import gurobipy as gp

# Create a new model
model = gp.Model("Paint_Blend")

# Define the variables
x = model.addVar(name="Egret", lb=0, ub=1)  # fraction of Egret paint
y = model.addVar(name="Crane", lb=0, ub=1)  # fraction of Crane paint

# Objective function: minimize cost
model.setObjective(0.40 * x + 1.20 * y, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(x + y == 1, name="Total_Fraction")  # total fraction equals 1
model.addConstr(60 * x + 85 * y >= 70, name="Quality_Rating")  # quality rating at least 70

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Fraction of Egret paint: {x.varValue}")
    print(f"Fraction of Crane paint: {y.varValue}")
    print(f"Minimum Cost: {model.objVal}")
else:
    print("No optimal solution found.")
