
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("pen_store")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # regular pens
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # premium pens


# Set objective function
m.setObjective(3*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, "demand_regular")
m.addConstr(x2 <= 50, "demand_premium")
m.addConstr(x1 + x2 <= 75, "total_sales")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of regular pens to sell: {x1.x}")
    print(f"Number of premium pens to sell: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

