
import gurobi

def solve_pen_store_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="x1")  # regular pens
    x2 = model.addVar(lb=0, name="x2")  # premium pens

    # Set the objective function
    model.setObjective(3*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 <= 100, name="demand_regular")
    model.addConstr(x2 <= 50, name="demand_premium")
    model.addConstr(x1 + x2 <= 75, name="total_demand")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_pen_store_problem()
