
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Scooter Production")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="foldable_scooters") # Number of foldable scooters
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="electric_scooters") # Number of electric scooters

# Set objective function
m.setObjective(150*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 3*x2 <= 4000, "design_constraint")
m.addConstr(4*x1 + 6*x2 <= 5000, "engineering_constraint")
m.addConstr(x1 >= 0, "non_negativity_foldable")
m.addConstr(x2 >= 0, "non_negativity_electric")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Foldable scooters: {x1.x:.2f}")
    print(f"Electric scooters: {x2.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

