
from gurobipy import *

# Create a new model
m = Model("ScooterProduction")

# Define variables
x1 = m.addVar(lb=0, name="foldable_scooters")
x2 = m.addVar(lb=0, name="electric_scooters")

# Set the objective function
m.setObjective(150*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 3*x2 <= 4000, "design_team_time")
m.addConstr(4*x1 + 6*x2 <= 5000, "engineering_team_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of foldable scooters: {x1.x}")
    print(f"Number of electric scooters: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
